/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.ntlm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.NetProperties;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.ntlm.NTLMAuthSequence;
import sun.net.www.protocol.http.ntlm.NTLMAuthenticationCallback;
import sun.security.action.GetPropertyAction;

public class NTLMAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private static final NTLMAuthenticationCallback NTLMAuthCallback = NTLMAuthenticationCallback.getNTLMAuthenticationCallback();
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", "domain"));
    private static final boolean ntlmCache;
    private static final TransparentAuth authMode;
    String username;
    String ntdomain;
    String password;
    private static Boolean isTrustedSiteAvailable;

    private void init0() {
        this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string;
                try {
                    string = InetAddress.getLocalHost().getHostName().toUpperCase();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
                return string;
            }
        });
        int n = this.hostname.indexOf(46);
        if (n != -1) {
            this.hostname = this.hostname.substring(0, n);
        }
    }

    public NTLMAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', AuthScheme.NTLM, uRL, "");
        this.init(passwordAuthentication);
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        this.pw = passwordAuthentication;
        if (passwordAuthentication != null) {
            String string = passwordAuthentication.getUserName();
            int n = string.indexOf(92);
            if (n == -1) {
                this.username = string;
                this.ntdomain = defaultDomain;
            } else {
                this.ntdomain = string.substring(0, n).toUpperCase();
                this.username = string.substring(n + 1);
            }
            this.password = new String(passwordAuthentication.getPassword());
        } else {
            this.username = null;
            this.ntdomain = null;
            this.password = null;
        }
        this.init0();
    }

    public NTLMAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', AuthScheme.NTLM, string, n, "");
        this.init(passwordAuthentication);
    }

    @Override
    protected boolean useAuthCache() {
        return ntlmCache && super.useAuthCache();
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static boolean supportsTransparentAuth() {
        return true;
    }

    public static boolean isTrustedSite(URL uRL) {
        if (NTLMAuthCallback != null) {
            return NTLMAuthCallback.isTrustedSite(uRL);
        }
        switch (authMode) {
            case TRUSTED_HOSTS: {
                return NTLMAuthentication.isTrustedSite(uRL.toString());
            }
            case ALL_HOSTS: {
                return true;
            }
        }
        return false;
    }

    private static native boolean isTrustedSiteAvailable0();

    private static boolean isTrustedSite(String string) {
        Boolean bl = isTrustedSiteAvailable;
        if (bl == null) {
            bl = NTLMAuthentication.isTrustedSiteAvailable0() ? Boolean.TRUE : Boolean.FALSE;
            isTrustedSiteAvailable = bl;
        }
        return bl != false && NTLMAuthentication.isTrustedSite0(string);
    }

    private static native boolean isTrustedSite0(String var0);

    @Override
    public String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String string) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            NTLMAuthSequence nTLMAuthSequence = (NTLMAuthSequence)httpURLConnection.authObj();
            if (nTLMAuthSequence == null) {
                nTLMAuthSequence = new NTLMAuthSequence(this.username, this.password, this.ntdomain);
                httpURLConnection.authObj(nTLMAuthSequence);
            }
            String string2 = "NTLM " + nTLMAuthSequence.getAuthHeader(string.length() > 6 ? string.substring(5) : null);
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            if (nTLMAuthSequence.isComplete()) {
                httpURLConnection.authObj(null);
            }
            return true;
        }
        catch (IOException iOException) {
            httpURLConnection.authObj(null);
            return false;
        }
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.ntlm.cache", "true"));
        ntlmCache = Boolean.parseBoolean(string);
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return NetProperties.get("jdk.http.ntlm.transparentAuth");
            }
        });
        authMode = "trustedHosts".equalsIgnoreCase(string2) ? TransparentAuth.TRUSTED_HOSTS : ("allHosts".equalsIgnoreCase(string2) ? TransparentAuth.ALL_HOSTS : TransparentAuth.DISABLED);
    }

    static enum TransparentAuth {
        DISABLED,
        TRUSTED_HOSTS,
        ALL_HOSTS;

    }
}

