/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.registry;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    private String mBundleLocation;
    private ResourceBundle mMsgBundle;
    private Locale mLastLocale;

    public MessageManager(String string) {
        this.mBundleLocation = string;
    }

    public final String getMessage(String string, Locale locale, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.getMessage(string, locale, objectArray);
    }

    public final String getMessage(String string, Locale locale) {
        return this.getMessage(string, locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getMessage(String string, Locale locale, Object[] objectArray) {
        String string2;
        try {
            ResourceBundle resourceBundle;
            MessageManager messageManager = this;
            synchronized (messageManager) {
                if (this.mMsgBundle == null || !locale.equals(this.mLastLocale)) {
                    this.mMsgBundle = ResourceBundle.getBundle(this.mBundleLocation, locale);
                    this.mLastLocale = locale;
                }
                resourceBundle = this.mMsgBundle;
            }
            string2 = MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "missing resource " + missingResourceException.getKey() + " in " + missingResourceException.getClassName();
        }
        catch (Exception exception) {
            string2 = "MessageManager: key " + string + " bundle " + this.mBundleLocation + " exception " + exception.toString();
        }
        return string2;
    }

    public static Object[][] getContents(Object[][] objectArray, String string) {
        int n = objectArray.length;
        Object[][] objectArray2 = new Object[n][2];
        for (int i = 0; i < n; ++i) {
            objectArray2[i][0] = objectArray[i][0];
            objectArray2[i][1] = string + objectArray[i][1];
        }
        return objectArray2;
    }
}

